 <?php
    include('../../include/db_conx.php');
    ?>

 <!DOCTYPE html>

 <html class="js backgroundsize borderimage csstransitions fontface svg details progressbar meter mathml cors largeview wb-enable" dir="ltr" xmlns="http://www.w3.org/1999/xhtml" lang="fr">
 <!--<![endif]-->

 <head prefix="og: http://ogp.me/ns#">
     <meta http-equiv="content-type" content="text/html; charset=UTF-8">

     <meta http-equiv="X-UA-Compatible" content="IE=edge">
     <meta charset="utf-8">
     <title>Avis — Immigration, Réfugiés et Citoyenneté</title>
     <meta content="width=device-width,initial-scale=1" name="viewport">

     <link rel="canonical" href="../../index.php" />


     <link rel="stylesheet" href="../../assets/css/wet-boew.css">
     <link rel="stylesheet" href="../../assets/css/theme.css">
     <link rel="stylesheet" href="../../assets/css/all.css" integrity="sha384-50oBUHEmvpQ+1lW4y57PTFmhCaXp0ML5d60M1M7uH2+nqUivzIebhndOJK28anvf" crossorigin="anonymous">

     <!--[if gte IE 9 | !IE ]><!-->
     <link rel="apple-touch-icon" sizes="57x57 72x72 114x114 144x144 150x150" class="wb-favicon" href="../../assets/img/favicon.png">
     <link href="../../assets/img/favicon.png" rel="shortcut icon" type="image/png" class="wb-init wb-favicon-inited">
     <link rel="stylesheet" href="../../assets/css/font-awesome.css">
     <script src="../../../use.fontawesome.com/4b789087e7.js"></script>

     <style>
         .view {
             background: #2597c7;
             color: #fff;
             padding: 3px 5px;
             font-size: small;
             -moz-border-radius: 5px;
             -ms-border-radius: 5px;
             -webkit-border-radius: 5px;
             border-radius: 5px;
         }

         .message {
             background: #080;
             color: #fff;
             padding: 3px 5px;
             font-size: small;
             -moz-border-radius: 5px;
             -ms-border-radius: 5px;
             -webkit-border-radius: 5px;
             border-radius: 5px;
         }

         .delete {
             background: #f00;
             color: #fff;
             padding: 3px 5px;
             font-size: small;
             -moz-border-radius: 5px;
             -ms-border-radius: 5px;
             -webkit-border-radius: 5px;
             border-radius: 5px;
         }
     </style>
 </head>

 <body vocab="http://schema.org/" typeof="WebPage">


     <div class="par iparys_inherited">

         <div class="global-header">
             <nav>
                 <ul id="wb-tphp" class="wb-init wb-disable-inited">
                     <li class="wb-slc"><a class="wb-sl" href="#wb-cont">Passer au contenu principal</a></li>
                     <li class="wb-slc"><a class="wb-sl" href="#wb-info">Passer à « Au sujet du gouvernement »</a></li>

                     <li class="wb-slc"><a class="wb-sl" rel="alternate" href="index.php">Passer à la version HTML simplifiée</a></li>
                 </ul>
             </nav>

             <header>
                 <div id="wb-bnr" class="container">

                     <section id="wb-lng" class="text-right">
                         <h2 class="wb-inv">Sélection de la langue</h2>
                         <div class="row" style="margin-top:20px">
                             <div class="col-md-12">
                                 <ul class="list-inline margin-bottom-none">
                                     <li>
                                         <a href="../../en/terms/index.php" lang="en">

                                             English
                                         </a>
                                     </li>


                                 </ul>
                             </div>
                         </div>
                     </section>
                     <div class="row">
                         <div class="brand col-xs-5 col-md-4" property="publisher" typeof="GovernmentOrganization">


                             <a href="../../index.php" property="url">
                                 <img src="../../assets/img/sig-blk-fr.svg" alt="" property="logo">
                                 <span class="wb-inv" property="name"> Gouvernement</span>
                             </a>

                             <meta property="areaServed" typeof="Country" content="">
                             <link property="logo" href="../../assets/img/wmms-blk.svg">
                         </div>

                     </div>
                 </div>
                 <nav class="gcweb-v2 gcweb-menu wb-init gcweb-menu-inited" typeof="SiteNavigationElement" id="wb-auto-2">
                     <div class="container">


                     </div>
                 </nav>



                 <nav id="wb-bc" property="breadcrumb">
                     <h2 class="wb-inv">You are here:</h2>
                     <div class="container">
                         <ol class="breadcrumb">
                             <li><a href="../../index.php"><?php echo $sitelink ?></a></li>
                             <li><a href="../index.php">Immigration, Réfugiés et Citoyenneté</a></li>
                             <li><a href="#">Renseignements organisationnels</a></li>
                         </ol>
                     </div>
                 </nav>


             </header>
         </div>



     </div>
     <main property="mainContentOfPage" resource="#wb-main" typeof="WebPageElement" class="container">


         <h1 property="name" id="wb-cont" dir="ltr">Avis — Immigration, Réfugiés et Citoyenneté</h1>




         <div>
             <div class="mwsbodytext text parbase section">



                 <p>Les présentes modalités sont propres à Immigration, Réfugiés et Citoyenneté. Les modalités du gouvernement, qui figurent ci-dessous, s’appliquent également&nbsp;:</p>
                 <ul>
                     <li>Emploi de fichiers situés sur des serveurs autres que ceux du gouvernement</li>
                     <li>Présentation d’un contenu dans les deux langues officielles</li>
                     <li>Établissement d’hyperliens vers des sites Web autres que ceux du gouvernement</li>
                     <li>Notre engagement à l’égard de l’accessibilité</li>
                 </ul>




             </div>
             <div class="mwsbodytext text parbase section">



                 <h2>Sur cette page</h2>



             </div>
             <div class="mwsbodytext text parbase section">



                 <ul>
                     <li><a href="#avis">Avis de confidentialité</a></li>
                     <li><a href="#ameliorer">Améliorer votre expérience sur notre site Web</a></li>
                     <li><a href="#propriete">Propriété et utilisation du contenu offert sur ce site</a></li>
                     <li><a href="#sociaux">Interagir avec nous au moyen des médias sociaux</a></li>
                 </ul>




             </div>
             <div class="mwshorizontalrule parbase section">
                 <hr>
             </div>
             <div class="mwsbodytext text parbase section">



                 <h2 id="avis">Avis de confidentialité</h2>




             </div>
             <div class="mwsbodytext text parbase section">



                 <p>Nous nous engageons à offrir des sites Web qui respectent la
                     confidentialité de ceux qui les consultent. Le présent avis de
                     confidentialité résume la politique et les pratiques de protection des
                     renseignements personnels pour nos activités en ligne.</p>
                 <p>Tous les renseignements recueillis par le Ministère sont protégés en vertu de la <a href="http://laws-lois.justice.gc.ca/fra/lois/P-21/index.html">Loi sur la protection des renseignements personnels</a>.
                     Ainsi, vous serez informé des raisons pour lesquelles ces
                     renseignements sont recueillis et de la façon d’exercer vos droits
                     d’accès à l’information.</p>
                 <p>Vous pouvez acheminer vos questions, commentaires ou plaintes au sujet de l’application de la <a href="http://laws-lois.justice.gc.ca/fra/lois/P-21/index.html">Loi sur la protection des renseignements personnels</a> et des politiques associées à notre présence sur le Web à la Division de l’accès à l’information et de la protection des renseignements personnels.</p>
                 <p>Si notre réponse à vos commentaires au sujet de la protection des
                     renseignements personnels ne vous satisfait pas, vous pouvez communiquer
                     avec le <a href="https://www.priv.gc.ca/fr/">Commissariat à la protection de la vie privée</a> au 1-800-282-1376.</p>
                 <h3>Votre confidentialité et Internet</h3>
                 <p>En raison de la nature d’Internet, les serveurs recueillent
                     automatiquement certains renseignements concernant la consultation d’un
                     site Web, y compris l’adresse du protocole Internet (IP) du visiteur.
                     L’adresse IP est une série de numéros unique attribuée par les
                     fournisseurs de services Internet (FSI) à tous les appareils utilisés
                     pour accéder à Internet. Les serveurs Web enregistrent automatiquement
                     les adresses IP des visiteurs. Cette adresse ne permet pas à elle seule
                     d’identifier une personne. Par contre, dans certaines circonstances,
                     comme avec la coopération d’un FSI par exemple, elle peut être utilisée
                     pour identifier une personne qui consulte le site. C’est pourquoi nous
                     considérons que l’adresse IP est un renseignement personnel, surtout si
                     elle est combinée à d’autres données automatiquement recueillies
                     lorsqu’un visiteur demande une page Web, telles que les pages consultées
                     ainsi que la date et l’heure de la visite.</p>
                 <p>À moins d’avis contraire, nous ne recueillons pas automatiquement de
                     renseignements précis à votre sujet, comme votre nom, votre numéro de
                     téléphone ou votre adresse électronique. Nous ne pouvons obtenir ce
                     genre de renseignements que si vous nous les fournissez, par exemple par
                     courriel ou au moyen d’un formulaire à remplir pour nous joindre en
                     ligne. Le cas échéant, la façon dont sont traités vos renseignements
                     personnels sera précisée dans un énoncé de collecte de renseignements
                     personnels.</p>
                 <p>Lorsque les services sont fournis par des organisations de
                     l’extérieur du gouvernement, comme les plateformes de médias
                     sociaux ou les applications mobiles, les adresses IP peuvent être
                     enregistrées par un serveur Web du fournisseur de services tiers.</p>
                 <h3>Pour communiquer avec nous</h3>
                 <p>Si vous choisissez de nous envoyer un courriel ou de remplir un
                     formulaire de rétroaction en ligne, nous utilisons vos renseignements
                     personnels pour répondre à votre demande de renseignements. Vos
                     renseignements seront communiqués à une autre institution
                     gouvernementale seulement si votre demande concerne cette institution.
                     Nous n’utilisons pas vos renseignements personnels pour créer des
                     profils individuels et nous ne les communiquons pas, sauf aux
                     fonctionnaires fédéraux qui en ont besoin pour répondre à votre demande.
                     La communication de vos renseignements personnels doit se faire
                     conformément à la <a href="http://laws-lois.justice.gc.ca/fra/lois/P-21/index.html">Loi sur la protection des renseignements personnels</a>.</p>
                 <p>Les renseignements personnels contenus dans les courriels ou les formulaires de rétroaction sont recueillis en vertu de la <a href="http://laws.justice.gc.ca/fra/lois/C-29.4/index.html">Loi sur le ministère de la Citoyenneté et de l’Immigration</a>, de la <a href="http://laws.justice.gc.ca/fra/lois/I-2.5/index.html">Loi sur l’immigration et la protection des réfugiés</a> et de la <a href="http://laws.justice.gc.ca/fra/lois/C-29/index.html">Loi sur la citoyenneté</a>.
                     Ils peuvent être utilisés à des fins statistiques, d’évaluation et de
                     production de rapports, et figurent dans le fichier de renseignements
                     personnels Communications publiques (POU&nbsp;914).</p>
                 <h3 id="courriel">Abonnez-vous aux mises à jour par courriel</h3>
                 <p>Si vous remplissez un formulaire en ligne pour vous abonner aux mises
                     à jour par courriel, nous utiliserons les renseignements que vous
                     fournissez pour vous envoyer les mises à jour.</p>
                 <p>Le fait de fournir vos renseignements personnels est un acte
                     volontaire et n’est nécessaire que si vous demandez à recevoir cette
                     information. Nous n’utiliserons vos renseignements personnels à aucune
                     autre fin, à moins d’indication contraire au moment de la saisie du
                     courriel.</p>
                 <p>Les renseignements personnels sont recueillis dans le cadre de la <a href="https://laws.justice.gc.ca/fra/lois/C-29.4/index.html">Loi sur le ministère de la Citoyenneté et de l’Immigration</a>, de la <a href="https://laws.justice.gc.ca/fra/lois/I-2.5/index.html">Loi sur l’immigration et la protection des réfugiés</a>, de <a href="https://laws.justice.gc.ca/fra/lois/C-29/index.html">la Loi sur la citoyenneté</a> et de la <a href="https://laws-lois.justice.gc.ca/fra/lois/f-11/">Loi sur la gestion des finances publiques</a> et conformément à la <a href="https://www.tbs-sct.gc.ca/pol/doc-fra.aspx?id=30683">Politique sur les communications et l’image de marque</a>.</p>
                 <p>La <a href="https://laws-lois.justice.gc.ca/fra/lois/P-21/index.html">Loi sur la protection des renseignements personnels</a>
                     accorde aux personnes le droit d’accéder à leurs renseignements
                     personnels, d’obtenir leur protection et d’en demander la modification.</p>
                 <p>Le fichier de renseignements personnels ordinaires POU&nbsp;914
                     (intitulé «&nbsp;Communications publiques&nbsp;») décrit plus en détail
                     la collecte, l’utilisation, la communication et la conservation de vos
                     renseignements personnels.</p>
                 <p>Si vous n’êtes pas satisfait de la façon dont nous avons traité vos
                     renseignements personnels, vous pouvez déposer une plainte au <a href="https://www.priv.gc.ca/fr/signaler-un-probleme/deposer-une-plainte-officielle-concernant-la-protection-de-la-vie-privee/">Commissariat à la protection de la vie privée</a>.</p>
                 <h3>L’assistant «&nbsp;Venir&nbsp;»</h3>
                 <p>L’information contenue dans l’assistant Venir sert à vous
                     guider au moment de déterminer les programmes d’immigration au titre
                     desquels vous pouvez présenter une demande. Aucune décision ne sera
                     rendue en fonction des réponses que vous fournirez dans l’assistant
                     Venir. Si vous décidez de présenter une demande, celle-ci sera
                     examinée par un agent, conformément à la Loi sur l’immigration et la
                     protection des réfugiés, quels que soient les résultats que vous aurez
                     obtenus après avoir rempli ce questionnaire.</p>
                 <p>L’assistant et les guides de demande ont été créés pour fournir des
                     directives générales aux demandeurs. Il peut toutefois arriver que des
                     renseignements ou des étapes supplémentaires soient nécessaires.</p>
                 <p>Vous devez fournir certains renseignements au moment d’utiliser
                     l’assistant Venir. Ces renseignements servent à vous aiguiller
                     vers l’information ayant trait au processus et aux documents à remplir
                     ou à présenter, en lien avec la demande que vous voulez faire. Si vous
                     utilisez le code de liste de contrôle personnel qui vous a été attribué
                     par l’assistant pour commencer à remplir votre demande en ligne dans
                     votre compte, il sera possible de récupérer les renseignements saisis au
                     moyen de l’assistant pour les réviser, et ceux-ci serviront à valider
                     les réponses que vous fournirez dans votre formulaire de demande. Si ces
                     renseignements changent, vous pourriez être redirigé vers l’assistant
                     pour valider les données que vous avez saisies. Celles-ci peuvent
                     également servir à diriger votre demande vers le bureau de traitement
                     concerné, et serviront à recueillir des données statistiques sur
                     l’utilisation de l’assistant Venir.</p>
                 <p>Si vous remplissez le formulaire de l’assistant Venir et
                     que vous recevez un code de liste de contrôle personnel, les données que
                     vous inscrirez dans l’assistant seront conservées de façon anonyme dans
                     une base de données pendant 60&nbsp;jours. Si, au contraire, vous ne
                     recevez pas de code de liste de contrôle personnel, vos données ne
                     seront pas conservées une fois que vous aurez fermé votre session. Si
                     vous devez présenter une demande en ligne au moyen de votre compte, les
                     données inscrites dans l’assistant seront conservées dans le fichier de
                     renseignements personnels correspondant à la demande que vous présentez,
                     pendant la durée indiquée dans ce fichier. Conformément à la Loi sur la
                     protection des renseignements personnels et à la Loi sur l’accès à
                     l’information, quiconque a le droit à la protection de ses
                     renseignements personnels et le droit d’y accéder. Pour en savoir plus
                     sur les fichiers de renseignements personnels, consultez le site Web
                     d’Infosource. Infosource est également accessible dans les bibliothèques
                     publiques partout.</p>
                 <h3>Médias sociaux de tiers</h3>
                 <p>Les renseignements personnels que vous fournissez au gouvernement par l’entremise de comptes de médias sociaux sont recueillis en
                     vertu de la <a href="http://laws.justice.gc.ca/fra/lois/C-29.4/index.html">Loi sur le ministère de la Citoyenneté et de l’Immigration</a>, de la <a href="http://laws.justice.gc.ca/fra/lois/I-2.5/index.html">Loi sur l’immigration et la protection des réfugiés</a>et de la <a href="http://laws.justice.gc.ca/fra/lois/C-29/index.html">Loi sur la citoyenneté</a>.
                     Ils sont recueillis afin de saisir des conversations (p. ex. questions
                     et réponses, commentaires, «&nbsp;j’aime&nbsp;», gazouillis partagés).
                     Ils peuvent être utilisés pour répondre à des demandes, effectuer des
                     évaluations statistiques ou produire des rapports. Tout commentaire qui
                     contrevient à la loi canadienne sera supprimé et porté à l’attention des
                     autorités chargées de l’application de la loi. Les commentaires qui
                     enfreignent nos règles de participation seront également supprimés. Les
                     renseignements personnels figurent dans le fichier de renseignements
                     personnels Activités de sensibilisation (POU&nbsp;938).</p>
                 <h2 id="ameliorer">Améliorer votre expérience sur notre site Web</h2>
                 <h3>Marqueurs numériques (y compris les témoins)</h3>
                 <p>Un marqueur numérique est une ressource créée par le navigateur de
                     l’utilisateur afin de retenir certains renseignements auxquels peut se
                     reporter le serveur Web dans le cadre de la même visite ou de visites
                     subséquentes. Les témoins et les spécifications de stockage Web HTML5
                     sont des exemples de marqueurs numériques. Voici quelques exemples de ce
                     que font les marqueurs numériques&nbsp;:</p>
                 <ul>
                     <li>Ils permettent à un site Web de reconnaître la dernière visite de l’utilisateur chaque fois qu’il consulte le site;</li>
                     <li>Ils enregistrent l’information consultée sur le site afin que les
                         administrateurs puissent s’assurer que les visiteurs trouvent ce qu’ils
                         cherchent.</li>
                 </ul>
                 <p>Nous utilisons des marqueurs numériques temporaires et permanents à
                     certains endroits sur notre site Web. Pendant votre visite en ligne,
                     votre navigateur échange des données avec notre serveur Web. Les
                     marqueurs numériques utilisés ne nous permettent pas d’identifier les
                     utilisateurs.</p>
                 <p>Vous pouvez modifier les paramètres de votre navigateur de manière à
                     rejeter les marqueurs numériques, y compris les témoins; sachez
                     toutefois qu’il pourrait être alors plus difficile d’interagir avec
                     notre site Web.</p>
                 <h3>Web analytique</h3>
                 <p>Le Web analytique est le terme utilisé pour désigner la collecte,
                     l’analyse, la mesure et la présentation de données sur la fréquentation
                     et les visites d’un site Web, dans le but de comprendre et d’optimiser
                     l’utilisation du Web.</p>
                 <p>Les renseignements recueillis par les marqueurs numériques peuvent
                     être utilisés dans le cadre du Web analytique pour garder en mémoire vos
                     interactions avec notre site Web. Lorsque vous consultez notre site
                     Web, nous recueillons les renseignements suivants&nbsp;:</p>
                 <ul>
                     <li>L’adresse IP de l’appareil (cette information n’est ni stockée ni
                         conservée dans un format qui permet d’établir l’identité d’un visiteur);</li>
                     <li>le type de navigateur utilisé;</li>
                     <li>le type de système d’exploitation;</li>
                     <li>la date et l’heure de la visite;</li>
                     <li>les pages consultées et les documents téléchargés.</li>
                 </ul>
                 <p>Ces renseignements personnels ne servent pas à la prise de décision
                     au sujet d’une personne ou à l’établissement du profil des visiteurs du
                     site caimmigrationchecker.com.</p>
                 <p>Nous avons recours aux services de 2&nbsp;tiers fournisseurs de
                     services, Adobe Systems Inc. (Adobe Analytics) et Google Inc. (Google
                     Analytics), pour améliorer notre site Web. Pour protéger les
                     renseignements concernant les visiteurs de notre site Web, nous nous
                     servons d’une fonction de chaque fournisseur de services, qui cache en
                     partie ou en totalité l’adresse IP d’un visiteur avant qu’elle ne soit
                     consignée.</p>
                 <p>Ces fournisseurs de services se trouvent aux États-Unis d’Amérique,
                     ce qui signifie que les renseignements personnels recueillis sont
                     transmis à l’extérieur et pourraient être visés par des lois
                     américaines, dont la Patriot Act.</p>
                 <p>En outre, Adobe et Google exploitent des serveurs situés dans
                     d’autres pays et sur lesquels des données d’analytique Web peuvent être
                     traitées. Par conséquent, ces données peuvent être assujetties aux lois
                     en vigueur dans le pays où elles sont traitées.</p>
                 <p>Dans le cas d’Adobe Analytics, le gouvernement a précisé
                     que les renseignements personnels peuvent uniquement être stockés dans
                     des serveurs, aux États-Unis, en Union européenne, en
                     Australie, en Israël, en Nouvelle‑Zélande, en Norvège et en Suisse.</p>
                 <p>Pour obtenir de plus amples renseignements concernant les politiques
                     de ces deux fournisseurs relativement à la protection de la vie privée,
                     consultez les sites suivants&nbsp;:</p>
                 <ul>
                     <li><a href="https://www.adobe.com/ca_fr/privacy/experience-cloud.html" rel="external">Politique de confidentialité d’Adobe Marketing Cloud</a></li>
                     <li><a href="https://policies.google.com/technologies/partner-sites?hl=fr-CA&amp;gl=ca" rel="external">Politique de confidentialité et conditions d’utilisation de Google Analytics</a></li>
                 </ul>
                 <p>Les données utilisées pour le Web analytique sont recueillies en vertu de la <a href="http://laws.justice.gc.ca/fra/lois/C-29.4/index.html">Loi sur le ministère de la Citoyenneté et de l’Immigration</a>, de la <a href="http://laws.justice.gc.ca/fra/lois/I-2.5/index.html">Loi sur l’immigration et la protection des réfugiés</a> et de la <a href="http://laws.justice.gc.ca/fra/lois/C-29/index.html">Loi sur la citoyenneté</a>.
                     Ces données peuvent servir à établir des statistiques sur les
                     communications et les technologies de l’information, et à faire des
                     vérifications, des évaluations, des recherches, ainsi que des activités
                     de planification et de production de rapports.</p>
                 <p>Pour en savoir plus sur la façon dont vos renseignements personnels sont protégés dans le cadre du Web analytique, consultez la <a href="https://www.tbs-sct.gc.ca/pol/doc-fra.aspx?id=26761">Norme sur la protection de la vie privée et le Web analytique</a>.</p>
                 <h3>Assurer la sécurité de notre site Web</h3>
                 <p>Nous utilisons des programmes logiciels pour surveiller le trafic du
                     réseau afin de repérer les tentatives non autorisées visant à
                     télécharger ou à modifier des renseignements ou à causer du tort. Ces
                     logiciels reçoivent et enregistrent l’adresse IP de l’ordinateur qui est
                     entré en communication avec notre site Web, la date et l’heure de la
                     visite et les pages consultées. Nous ne tentons aucunement d’associer
                     ces adresses à l’identité des personnes qui consultent notre site, à
                     moins qu’il y ait tentative d’endommager le site.</p>
                 <p>Ces données sont recueillies en vertu de <a href="http://laws-lois.justice.gc.ca/fra/lois/F-11/TexteComplet.html#s-161">l’article&nbsp;161 de la Loi sur la gestion des finances publiques</a>.
                     Les renseignements peuvent être communiqués aux autorités chargées de
                     l’application de la loi si l’on soupçonne des activités criminelles. Ils
                     peuvent être utilisés pour établir des statistiques sur la sécurité du
                     réseau, ainsi qu’à des fins de vérification, d’évaluation, de recherche,
                     de planification et de production de rapports, et figurent dans le
                     fichier de renseignements personnels Incidents de sécurité et atteintes à la vie privée (POU&nbsp;939).</p>
                 <h3>Propriété des passeports canadiens</h3>
                 <p>Tous les passeports et titres de voyage délivrés par le sont
                     la propriété du gouvernement, comme le prévoit le Décret sur
                     les passeports canadiens. Toute référence à «&nbsp;votre
                     passeport&nbsp;» ou au «&nbsp;passeport de votre enfant&nbsp;» dans le
                     présent site Web vise uniquement à faciliter la communication et
                     n’indique aucune propriété.</p>
                 <h3>Accessibilité</h3>
                 <p>Nous sommes déterminé à maintenir une norme d’accessibilité élevée conformément à la <a href="http://www.tbs-sct.gc.ca/pol/doc-fra.aspx?id=23601">Norme sur l’accessibilité des sites Web</a> et la <a href="http://www.tbs-sct.gc.ca/pol/doc-fra.aspx?id=27088">Norme sur l’optimisation des sites Web et des applications pour appareils mobiles</a>.
                     Veuillez communiquer avec nous si vous éprouvez des difficultés à
                     utiliser nos pages Web, les applications ou les applications mobiles
                     axées sur l’appareil, ou si vous désirez obtenir des formats de
                     substitution comme le caractère ordinaire, le Braille ou un autre format
                     approprié.</p>
                 <h2 id="propriete">Propriété et utilisation du contenu offert dans ce site</h2>
                 <p>Le contenu de ce site Web a été produit ou rassemblé par Immigration,
                     Réfugiés et Citoyenneté afin d’offrir aux Canadiens l’accès aux
                     renseignements concernant les programmes et services offerts par le
                     gouvernement. Vous pouvez utiliser et reproduire le contenu
                     des façons suivantes&nbsp;:</p>
                 <p>Le matériel diffusé sur le présent site est protégé par les dispositions de la <a href="http://laws-lois.justice.gc.ca/fra/lois/C-42/index.html">Loi sur le droit d’auteur</a>
                     et par les lois, les politiques, les règlements et les accords
                     internationaux. Ces dispositions servent à déterminer la
                     source d’information et, dans certains cas, à interdire la reproduction
                     de matériel sans permission écrite.</p>
                 <h3>Reproduction non commerciale</h3>
                 <p>À moins d’avis contraire, vous pouvez reproduire le contenu en
                     totalité ou en partie à des fins non commerciales, dans un format
                     quelconque, sans frais ni autre permission, à condition&nbsp;:</p>
                 <ul>
                     <li>de faire preuve de diligence raisonnable quant à la précision du contenu reproduit;</li>
                     <li>de préciser le titre complet du contenu reproduit, ainsi que l’auteur (s’il y a lieu);</li>
                     <li>de préciser qu’il s’agit d’une reproduction de la version disponible au [URL où le document original se trouve].</li>
                 </ul>
                 <h3>Reproduction commerciales</h3>
                 <p>À moins d’avis contraire, il est interdit de reproduire le contenu de
                     ce site, en totalité ou en partie, à des fins de diffusion commerciale
                     sans avoir obtenu au préalable la permission écrite d’Immigration,
                     Réfugiés et Citoyenneté .</p>
                 <p>Une partie du contenu de ce site peut être assujettie au droit
                     d’auteur d’une tierce partie. Lorsque de l’information est produite par
                     une tierce partie ou que le gouvernement n’est pas le
                     détenteur du droit d’auteur, le contenu est protégé par la <a href="http://laws-lois.justice.gc.ca/fra/lois/C-42/index.html">Loi sur le droit d’auteur</a> et les ententes internationales. Les détails relatifs au droit d’auteur sont indiqués aux pages pertinentes.</p>
                 <p>Pour obtenir la permission de reproduire notre contenu publié sur le
                     présent site à des fins commerciales, veuillez demander
                     l’affranchissement du droit d’auteur.</p>




             </div>
             <div class="mwspagination section">

                 <p><a class="btn btn-primary" href="https://secure.cic.gc.ca/ccc-ada/step-etape-1-fra.aspx">Demande d'affranchissement du droit d'auteur</a></p>



             </div>
             <div class="mwsbodytext text parbase section">



                 <h3>Reproduction des symboles gouvernementaux</h3>



             </div>
             <div class="mwsbodytext text parbase section">



                 <p>Pour obtenir de plus amples renseignements sur la propriété
                     et les restrictions en matière de droit d’auteur, veuillez communiquer
                     avec&nbsp;:</p>
                 <p class="mrgn-lft-lg">Immigration, Réfugiés et Citoyenneté <br>
                     Services de publication et de création<br>
                     300, rue Slater, 3<sup>e</sup>&nbsp;étage&nbsp;<br>
                     Ottawa, (Ontario)<br>
                     K1A 1L1</p>
                 <h3>Avis concernant l’image de marque</h3>
                 <p>La reproduction des symboles officiels du gouvernement, y
                     compris le mot-symbole, les armoiries et
                     le symbole du drapeau, à des fins commerciales ou non commerciales, est
                     interdite sans autorisation écrite au préalable.</p>
                 <h2 id="sociaux">Médias sociaux</h2>
                 <h3>Tiers fournisseurs de services</h3>
                 <p>Les serveurs qui hébergent nos plateformes de médias sociaux sont
                     gérés par un tiers. Il peut arriver, à l’occasion, que ces serveurs ne
                     fonctionnent pas correctement. Nous n’y pouvons rien et nous dégageons
                     de toute responsabilité en cas de non‑disponibilité des plateformes.</p>
                 <p>Les renseignements contenus dans des sites ne relevant pas du gouvernement ne sont pas assujettis à la <a href="http://laws-lois.justice.gc.ca/fra/lois/P-21/index.html">Loi sur la protection des renseignements personnels</a> ni à la <a href="http://laws-lois.justice.gc.ca/fra/lois/O-3.01/">Loi sur les langues officielles</a> et peuvent ne pas être accessibles aux personnes handicapées.</p>
                 <p>Le gouvernement n’a aucun contrôle sur les conditions d’utilisation
                     ou de service des fournisseurs de plateformes de médias sociaux. Nous
                     vous encourageons fortement à lire ces conditions en plus de celles qui
                     suivent. Les visiteurs devraient examiner les politiques de protection
                     des renseignements personnels de ces sites non gouvernementaux avant de
                     fournir des renseignements personnels.</p>
                 <h3>Contenu</h3>
                 <p>Nous utilisons les médias sociaux comme un moyen autre d’interagir
                     avec les utilisateurs et les intervenants au sujet de nos programmes et
                     services. Nous lirons les commentaires et participerons aux discussions
                     sur nos comptes de médias sociaux lorsque nous le jugerons approprié. Si
                     vous nous suivez, si vous «&nbsp;aimez&nbsp;» notre page ou si vous
                     vous abonnez à notre contenu, vous pouvez vous attendre à trouver de
                     l’information sur les programmes que nous exécutons et les services que
                     nous fournissons.</p>
                 <p>Nous ne participerons à aucune discussion et ne répondrons à aucune question de politique partisane.</p>
                 <p>Nous ne pouvons répondre à aucune question propre à un cas
                     particulier et demandons aux utilisateurs de ne publier aucun
                     renseignement personnel. Nous nous réservons le droit de supprimer ce
                     genre de contenu.</p>
                 <h3>Partage</h3>
                 <p>Les énoncés sur la reproduction à des fins commerciales et non
                     commerciales s’appliquent au contenu publié sur nos comptes de médias
                     sociaux.</p>
                 <p>Tant que ce contenu n’est modifié d’aucune façon, nous encourageons
                     les utilisateurs à faire usage des fonctions et des outils offerts sur
                     les plateformes de médias sociaux pour le diffuser plus largement
                     (p.&nbsp;ex. partage, intégration et retransmission). Nous ne vérifions
                     pas et ne confirmons pas l’exactitude du contenu retransmis ou partagé
                     par les utilisateurs. Les opinions et points de vue exprimés sont ceux
                     du ou des auteurs et ne reflètent pas nécessairement ceux du Ministère
                     ou du gouvernement.</p>
                 <h3>Fréquence</h3>
                 <p>Bien que les médias sociaux fonctionnent 24&nbsp;heures par jour,
                     7&nbsp;jours par semaine, nos comptes sont habituellement gérés du lundi
                     au vendredi (HNE), durant les heures de bureau. Il peut nous arriver de
                     publier du nouveau contenu en d’autres temps, par exemple en situation
                     d’urgence ou si des renseignements sont susceptibles d’être importants
                     pour notre communauté de médias sociaux. Peu importe le moment de la
                     publication, il est à noter que nous ne répondrons à aucun commentaire
                     ni à aucune question en dehors des heures normales de bureau, la fin de
                     semaine ou les jours fériés. Nous nous efforçons de répondre à toutes
                     les questions dans un délai de deux&nbsp;jours ouvrables. Il se peut que
                     nous retirions du contenu de nos comptes de médias sociaux sans
                     préavis.</p>
                 <h3>Suivre, marquer comme «&nbsp;Favori&nbsp;» et s’abonner</h3>
                 <p>Les actions suivantes ne constituent pas une approbation implicite
                     d’un compte, d’une page, d’une personne, d’un groupe ou d’un site&nbsp;:</p>
                 <ul>
                     <li>suivre, marquer comme «&nbsp;favori&nbsp;», s’abonner ou utiliser toute fonction similaire d’un compte de média sociaux;</li>
                     <li>partager le contenu d’autres utilisateurs (p.&nbsp;ex. la
                         retransmission d’un gazouillis, la republication ou l’insertion
                         d’hyperliens);</li>
                     <li>utiliser la fonction «&nbsp;J’aime&nbsp;», le pouce en l’air, la
                         mention «&nbsp;Favori&nbsp;» ou toute autre fonction se rapportant au
                         contenu publié par l'intermédiaire d'un autre compte ou utilisateur.</li>
                 </ul>
                 <h3>Commentaires et messages privés</h3>
                 <p>Les opinions et les points de vue exprimés en réaction à nos
                     publications dans les médias sociaux (p.&nbsp;ex. commentaires sur nos
                     comptes Facebook ou YouTube ou encore utilisation de nos pseudonymes
                     dans un gazouillis) sont ceux du ou des auteurs et ne reflètent pas ceux
                     du Ministère ou du gouvernement.</p>
                 <p>IRCC peut supprimer du contenu ou bloquer des utilisateurs en fonction des critères suivants&nbsp;:</p>
                 <ul>
                     <li>propos racistes, haineux, sexistes, homophobes, diffamatoires, insultants ou menaçants;</li>
                     <li>accusations non fondées ou inexactes concernant des personnes ou des organisations;</li>
                     <li>contenu agressif, vulgaire, violent, obscène ou pornographique;</li>
                     <li>comportement insultant, impoli ou injurieux à l’endroit d’une personne ou d’une organisation;</li>
                     <li>activités d’autopromotion;</li>
                     <li>appui d’une activité illégale;</li>
                     <li>annonces provenant d’organisations syndicales ou politiques;</li>
                     <li>contenu répétitif ou constituant du pollupostage qui nuit à la prestation équitable des services;</li>
                     <li>renseignements personnels;</li>
                     <li>propos contrevenant aux principes de la Charte canadienne des droits et libertés.</li>
                 </ul>
                 <p>En résumé, soyez respectueux et veillez à ce que vos commentaires
                     soient pertinents, selon l’endroit où vous les publiez. Les points de
                     vue des utilisateurs qui formulent des commentaires sur nos comptes de
                     médias sociaux ne représentent pas nécessairement les points de vue du
                     gouvernement.</p>
                 <h4 id="robotdediscussion">Interaction avec notre robot de discussion</h4>
                 <p>Lorsque vous communiquez avec nous sur Facebook Messenger, votre
                     première interaction est avec Quaid, un robot de discussion qui nous
                     aide à répondre à vos questions. Si Quaid ne peut répondre à votre
                     question, il demandera à l’un de nos agents d’y répondre à sa place.</p>
                 <p>Vous devez garder plusieurs éléments en tête lorsque vous discutez avec Quaid ou directement avec nous.</p>
                 <h5>Les réponses de Quaid sont générales et fondées sur des circonstances typiques.</h5>
                 <p>Votre situation peut être différente, et la réponse pourrait ne pas convenir à votre situation.</p>
                 <h5>Les réponses de Quaid ou de nos agents n’auront aucune incidence sur votre demande.</h5>
                 <p>Vos conversations avec Quaid ou avec nos agents&nbsp;:</p>
                 <ul>
                     <li>ne garantissent pas que nous accepterons votre demande (ce sont nos agents d’immigration qui décident);</li>
                     <li>ne sont pas liées à votre demande ou à votre compte;</li>
                     <li>ne remplacent pas l’avis donné par les représentants autorisés.</li>
                 </ul>
                 <h5>Nous pourrions mettre fin à des conversations sur Messenger qui dérogent à nos conditions d’utilisation.</h5>
                 <p>Si nous vous bloquons parce que vous n’avez pas respecté les
                     conditions d’utilisation, vous ne pourrez pas vous servir de ce moyen
                     pour communiquer avec nous à l’avenir.</p>
                 <h5>Nous pourrions conserver votre question pour aider à former Quaid.</h5>
                 <p>Plus le robot de discussion traite de&nbsp;questions, plus Quaid
                     devient intelligent. Toutefois, nous ne conservons pas vos
                     renseignements de profil, votre historique de publications ou toute
                     autre interaction à des fins de formation.</p>
                 <h3>Langues officielles</h3>
                 <p>Nous répondons aux questions et aux commentaires dans la langue
                     officielle dans laquelle ils sont publiés. Si nous sommes d’avis que la
                     réponse est d’intérêt public, il se peut que nous répondions dans les
                     deux langues officielles.</p>
                 <p>Il peut arriver que nous publiions des liens qui dirigent les
                     utilisateurs vers les sites Web d’organisations ou d’autres entités qui
                     ne sont pas assujettis à la <a href="http://laws-lois.justice.gc.ca/fra/lois/O-3.01/">Loi sur les langues officielles</a>.
                     Si du contenu externe n’est pas disponible dans les deux langues
                     officielles, nous essaierons de présenter du contenu similaire dans
                     l’autre langue. Tout renseignement présenté dans une langue autre que le
                     français ou l’anglais est offert à nos visiteurs à des fins pratiques
                     uniquement.</p>



             </div>

         </div>
         <div class="pagedetails ">
             <dl id="wb-dtmd">
                 <dt>Date de modification :</dt>
                 <dd><time property="dateModified">2021-08-19</time></dd>
             </dl>
         </div>
     </main>



     <div class="par iparys_inherited">


         <div class="global-footer">
             <footer id="wb-info">

                 <div class="brand">
                     <div class="container">
                         <div class="row">
                             <nav class="col-md-10 ftr-urlt-lnk">

                             </nav>
                             <div class="col-xs-6 visible-sm visible-xs tofpg">
                                 <a href="#wb-cont">Haut de la page <span class="fa fa-chevron-up"></span></a>
                             </div>
                             <div class="col-xs-6 col-md-2 text-right">
                                 <img src="../../assets/img/wmms-blk.svg" alt="Symbol of the Government">
                             </div>
                         </div>
                     </div>
                 </div>
             </footer>

         </div>



     </div>

     <script type="text/javascript" src="../../assets/js/jquery_003.js"></script>
     <script type="text/javascript" src="../../assets/js/utils.js"></script>


     <!--[if gte IE 9 | !IE ]><!-->
     <script src="../../assets/js/jquery_002.js"></script>
     <script src="../../assets/js/wet-boew.js"></script>
     <span id="wb-rsz" class="wb-init">&nbsp;</span>
     <!--<![endif]-->



     <script src="../../assets/js/theme.js"></script>


 </body>

 </html>